/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.circuit.placement;

import com.technicalitiesmc.lib.circuit.component.ComponentSlot;
import com.technicalitiesmc.lib.circuit.component.ComponentState;
import com.technicalitiesmc.lib.circuit.component.ComponentType;
import com.technicalitiesmc.lib.math.VecDirection;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.core.Vec3i;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;

public interface PlacementContext {

    public static interface MultiPlacementContext {
        default public boolean at(Vec3i pos, ComponentType type) {
            return this.at(pos, type, type::create);
        }

        public boolean at(Vec3i var1, ComponentType var2, ComponentType.Factory var3);
    }

    public static interface Server {
        public Player getPlayer();

        default public boolean tryPut(Vec3i pos, ComponentType type) {
            return this.tryPut(pos, type, type::create);
        }

        public boolean tryPut(Vec3i var1, ComponentType var2, ComponentType.Factory var3);

        public boolean tryPutAll(Predicate<MultiPlacementContext> var1);

        public void consumeItems(int var1);

        public void consumeItems(Item var1, int var2);

        public void playSound();
    }

    public static interface Client {
        public Player getPlayer();

        public InteractionHand getHand();

        default public ItemStack getStack() {
            return this.getPlayer().m_21120_(this.getHand());
        }

        public VecDirection getFacing();

        public VecDirection getHorizontalFacing();

        @Nullable
        public ComponentState get(Vec3i var1, ComponentSlot var2);

        public boolean canPlace(Vec3i var1, ComponentType var2);

        public boolean isTopSolid(Vec3i var1);

        public boolean isWithinBounds(Vec3i var1);

        public boolean isModifierPressed();
    }
}

